/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai.attack;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.pathfinding.Path;
import noppes.npcs.ai.attack.EntityAICustom;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class EntityAICommanderTarget
extends EntityAICustom {
    public int baseAnimation;
    private final List<EntityNPCInterface> npcs = new ArrayList<EntityNPCInterface>();
    private boolean done = false;
    private int time = 0;
    private double minDist;

    public EntityAICommanderTarget(IRangedAttackMob npc) {
        super(npc);
        this.baseAnimation = this.npc.currentAnimation;
        this.npc.aiOwnerNPC = null;
    }

    private void attack() {
        this.done = true;
        this.time = 0;
        if (this.npc.currentAnimation != this.baseAnimation) {
            this.npc.setCurrentAnimation(this.baseAnimation);
        }
        for (EntityNPCInterface n : this.npcs) {
            n.aiOwnerNPC = null;
            n.func_70624_b(this.target);
            if (!(n.aiAttackTarget instanceof EntityAICommanderTarget)) continue;
            ((EntityAICommanderTarget)n.aiAttackTarget).done = true;
        }
        this.npcs.clear();
    }

    private void reset() {
        this.done = false;
        this.time = 0;
        if (this.npc.currentAnimation != this.baseAnimation) {
            this.npc.setCurrentAnimation(this.baseAnimation);
        }
        for (EntityNPCInterface n : this.npcs) {
            n.aiOwnerNPC = null;
            if (!n.ais.returnToStart) continue;
            n.func_70661_as().func_75492_a((double)n.getStartXPos(), n.getStartYPos(), (double)n.getStartZPos(), 1.3);
        }
        this.npcs.clear();
    }

    @Override
    public boolean func_75250_a() {
        if (super.func_75250_a()) {
            return true;
        }
        this.reset();
        return false;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.isFriend || this.npc.field_70173_aa % (this.tickRate * 2) > 3) {
            return;
        }
        this.canSeeToAttack = this.isRanged ? Util.instance.npcCanSeeTarget((EntityLivingBase)this.npc, this.target, true, true) : this.npc.canSee((Entity)this.target);
        if (this.done) {
            if (this.canSeeToAttack && this.distance <= this.range) {
                if (this.inMove) {
                    this.npc.func_70661_as().func_75499_g();
                }
            } else {
                this.tryMoveToTarget();
            }
            this.tryToCauseDamage();
        } else {
            if (this.canSeeToAttack && this.distance <= this.range && this.distance <= (double)this.tacticalRange) {
                this.attack();
                return;
            }
            if (this.npcs.isEmpty()) {
                for (EntityNPCInterface n : Util.instance.getEntitiesWithinDist(EntityNPCInterface.class, this.npc.field_70170_p, (Entity)this.npc, (double)this.tacticalRange)) {
                    Path path;
                    if (this.npc.equals((Object)n) || this.npc.getFaction().id != n.getFaction().id || n.func_70638_az() != null || n.ais.onAttack != 0 && n.ais.onAttack != 2 || n.aiOwnerNPC != null || (path = n.func_70661_as().func_179680_a(this.npc.func_180425_c())) == null) continue;
                    this.npcs.add(n);
                    n.func_70661_as().func_75484_a(path, 1.0);
                    n.aiOwnerNPC = this.npc;
                }
                if (this.npcs.isEmpty()) {
                    this.attack();
                    return;
                }
                this.npc.setCurrentAnimation(4);
                this.minDist = this.npcs.size() < 5 ? 3.0 : 0.4 * (double)this.npcs.size() + 1.0;
                this.time = this.tacticalRange < 5 ? 18 : (int)(4.90909f * (float)this.tacticalRange - 6.54545f);
            } else {
                boolean isStart = true;
                for (EntityNPCInterface n : this.npcs) {
                    float dist;
                    if (n.aiOwnerNPC == null) {
                        n.aiOwnerNPC = this.npc;
                    }
                    if ((double)(dist = this.npc.func_70032_d((Entity)n)) > this.minDist) {
                        isStart = false;
                        n.func_70661_as().func_75497_a((Entity)this.npc, 1.0);
                        continue;
                    }
                    if (!((double)dist < 1.5)) continue;
                    n.func_70661_as().func_75499_g();
                }
                --this.time;
                if (isStart || this.time <= 0) {
                    this.attack();
                }
            }
        }
    }
}

